//
//  RasterImage.m
//  POSSDKForIOS 2013-07-25
//
//  Created by liangchenying on 12-4-10.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserve-d.
//

#import "RasterImage.h"
#import "ButtonPullDownPrepare.h"
#import "ButtonPullDownRealize.h"

@interface RasterImage()
@property (nonatomic, retain) POSSDK	 *pos_sdk;
@end

@implementation RasterImage

@synthesize RasterImageName;
@synthesize Back;
@synthesize Cut;
@synthesize RasterImageWidth;
@synthesize RasterImagePrint;
@synthesize pos_sdk      = _pos_sdk;


- (id)initWithNibNamePOSSDK:(NSString *)nibNameOrNil pos_sdk:(POSSDK*)pos_sdk bundle:(NSBundle *)nibBundleOrNil
{
    self.pos_sdk = pos_sdk;
    return [self initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) 
    {
    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self.RasterImageName  setDelegate:self];
    [self.RasterImageWidth setDelegate:self];
    [self.RasterImageName  setText:@"SAMPLE.bmp"];
    [self.RasterImageWidth setText:@"500"];
}

- (void)viewDidUnload
{
    [self setRasterImageName:nil];
    [self setBack:nil];
    [self setCut:nil];
    [self setRasterImageWidth:nil];  
    [self setRasterImagePrint:nil];
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

//**************************************************************************************************
//Exit the keyboard by clicking "return"
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if ([string isEqualToString:@"\n"])
    {
        [self.RasterImageName  resignFirstResponder];
        [self.RasterImageWidth resignFirstResponder];
        return NO;
    } 
return YES;
}

//**************************************************************************************************
//Return to the main View by press the button "Back"
- (IBAction)Back:(id)sender 
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

//**********************************************************************************************
//Cut paper
- (IBAction)Cut:(id)sender
{
    SInt32 error_code = SUCCESS;
    
    error_code = [self.pos_sdk systemCutPaper:CutPartAfterFeed FeedDistance:80];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }
    
ExitLine:
    return;
}

//**************************************************************************************************
//Raster Image Print
- (IBAction)Print:(id)sender 
{
    SInt32 error_code    = SUCCESS;
    SInt32 width         = 0;
    NSString *image_name = nil;
	NSString *full_path  = nil;
	UIImage  *image      = nil;
	SInt32   i           = 0;
  
    
    //**********************************************************************************************
	//Get image
	image_name = self.RasterImageName.text;
    full_path  = [[[NSBundle mainBundle] bundlePath] stringByAppendingPathComponent:image_name];
    image      = [[UIImage alloc] initWithContentsOfFile:full_path];
    
    JudgeParamNil(RasterImageName, @"Image Name == nil , Please Input Image Name");
   
    if (image == nil) 
    {
        AlertViewShow(@"Image is not exist,please check image name.");
        goto ExitLine;
    }

    //**********************************************************************************************
	//Printer width cannot be nil,
    JudgeParamNil(RasterImageWidth, @"PrinterWidth == nil,Please input Printer Width");
    
    //**********************************************************************************************
	//Judge printer width must be digits
    JudgeParamDigitOrNot(RasterImageWidth, @"ERROR Printer width! It must be   0  or 64-2040.");
    
    //**********************************************************************************************
	//Printer width must be 0 or 64-2040
    width = [self.RasterImageWidth.text intValue];
    JudgePrinterWidthRange(width,@"ERROR Printer width! It must be  0  or 64-2040.",2040);

    //**********************************************************************************************
	//Print raster image
    error_code = [self.pos_sdk  imageStandardModeRasterPrint:image PrinterWidth:width];
    if (error_code == ERR_INVALID_DATA)
    {
        AlertViewShow(@"Please ckeck the image!");
		goto ExitLine;
    }
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }

 ExitLine:   
        [image release];
    return;   
}

- (void)dealloc
{
    [self.RasterImageName release];
    [self.Back release];
    [self.Cut release];
    [self.RasterImageWidth release];   
    [self.RasterImagePrint release];
    [super dealloc];
}

@end
